/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity.ai;

import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.entity.AncientBlazeEntity;
import com.tristankechlo.livingthings.init.ModSounds;
import java.util.EnumSet;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;

public class AncientBlazeChargeUpGoal
extends Goal {
    private final AncientBlazeEntity blaze;

    public AncientBlazeChargeUpGoal(AncientBlazeEntity entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.blaze = entity;
    }

    public boolean m_8036_() {
        return this.blaze.getInvulnerableTime() > 0;
    }

    public void m_8037_() {
        int divider;
        int chargedtime = this.blaze.getInvulnerableTime();
        int targetShoots = AncientBlazeConfig.largeFireballAmount();
        if (chargedtime > 0 && --chargedtime % (divider = AncientBlazeConfig.chargingTime() / targetShoots) < 1 && this.blaze.getShoots() < targetShoots) {
            this.blaze.setShoots((byte)(this.blaze.getShoots() + 1));
            if (!this.blaze.m_9236_().m_5776_()) {
                this.blaze.m_9236_().m_5594_(null, this.blaze.m_20183_(), ModSounds.ANCIENT_BLAZE_CHARGE_UP.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
        if (chargedtime == 0) {
            SmallFireball smallfireballentity;
            double accelZ;
            double accelX;
            int i;
            this.blaze.m_21153_(this.blaze.m_21233_());
            this.blaze.setShoots((byte)targetShoots);
            if (!this.blaze.m_9236_().m_5776_()) {
                this.blaze.m_9236_().m_5594_(null, this.blaze.m_20183_(), ModSounds.ANCIENT_BLAZE_SPAWN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            for (i = 0; i < 4; ++i) {
                accelX = Math.pow(-1.0, i) * 90.0;
                accelZ = i < 2 ? 90.0 : -90.0;
                smallfireballentity = new SmallFireball(this.blaze.m_9236_(), (LivingEntity)this.blaze, accelX, -15.0, accelZ);
                smallfireballentity.m_6034_(smallfireballentity.m_20185_(), this.blaze.m_20227_(0.5), smallfireballentity.m_20189_());
                this.blaze.m_9236_().m_7967_((Entity)smallfireballentity);
            }
            for (i = 0; i < 4; ++i) {
                accelX = i > 1 ? Math.pow(-1.0, i) * 90.0 : 0.0;
                accelZ = i < 2 ? Math.pow(-1.0, i) * 90.0 : 0.0;
                smallfireballentity = new LargeFireball(this.blaze.m_9236_(), (LivingEntity)this.blaze, accelX, -15.0, accelZ, 1);
                smallfireballentity.m_6034_(smallfireballentity.m_20185_(), this.blaze.m_20227_(0.5) + 0.5, smallfireballentity.m_20189_());
                this.blaze.m_9236_().m_7967_((Entity)smallfireballentity);
            }
        }
        this.blaze.setInvulnerableTime(chargedtime);
    }
}

